% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.fill.R
\name{gap.fill}
\alias{gap.fill}
\title{Gap filling by linear interpolation}
\usage{
gap.fill(input, max.gap = 60, decimals = 10, df = FALSE)
}
\arguments{
\item{input}{an \code{\link{is.trex}}-compliant object.}

\item{max.gap}{Numeric value providing the maximum size of a gap in minutes,
which can be filled by performing a linear interpolation.}

\item{decimals}{Integer value defining the number of decimals of the output (default = 10).}

\item{df}{Logical; if \code{TRUE}, output is provided in a \code{data.frame}
format with a timestamp and a value (\eqn{\Delta T} or \eqn{\Delta V}) column.
If \code{FALSE}, output is provided as a \code{zoo} object (default = FALSE).}
}
\value{
A \code{zoo} object or \code{data.frame} in the appropriate format for further processing.
}
\description{
Fills gaps by linear interpolation between observations.
This function provides the option to define the minimum window under which gaps should
be filled, using linear interpolation.
}
\examples{
\donttest{
# fill two hour gaps
raw   <- example.data(type = "doy")
input <-
  is.trex(
    raw,
    tz = "GMT",
    time.format = "\%H:\%M",
    solar.time = TRUE,
    long.deg = 7.7459,
    ref.add = FALSE,
    df = FALSE)

# create gaps in data
input[which(input < 0.4 | input > 0.82)] <- NA
fill_120 <- gap.fill(
  input = input,
  max.gap = 120,
  decimals = 10,
  df = FALSE)
fill_15 <- gap.fill(
  input = input,
  max.gap = 15,
  decimals = 10,
  df = FALSE)
  }
}
