## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(TPMplt)
head(TPMdata[,1:3])


## ------------------------------------------------------------------------
colnames(TPMdata)

## ------------------------------------------------------------------------
require(VBTree)
dl2vbt(chrvec2dl(colnames(TPMdata)))

## ------------------------------------------------------------------------
epstable <- epsExtract(TPMdata, eps = 0.7, lyT = 2, lySR = 3)
epstable

## ------------------------------------------------------------------------
DMM <- DMMprocess(epstable)
DMM

## ------------------------------------------------------------------------
DMM <- DMMprocess(epstable, ConsFunc = TRUE)

## ------------------------------------------------------------------------
PLTbd <- SVRModel(DMM)

## ---- fig.show='hold', fig.height=4, fig.width=6-------------------------
TPM2dplt(PLTbd)

## ------------------------------------------------------------------------
TPM3dplt(PLTbd)

