% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap_analysis.R
\name{umap_analysis}
\alias{umap_analysis}
\title{UMAP analysis for analyzing RNA-Seq data.}
\usage{
umap_analysis(sample_gene, group_sample, seed = 1, method = "naive")
}
\arguments{
\item{sample_gene}{Dataframe: gene expression dataframe (1st-col: Transcripts or Genes, 2nd-col~: Samples).}

\item{group_sample}{Dataframe: Samples and groups for gene expression (1st-col: Samples, 2nd-col: Groups).}

\item{seed}{Numeric: set seed for robust result. Default: 1.}

\item{method}{Character: 'naive' (an implementation written in pure R) and 'umap-learn' (requires python package 'umap-learn').}
}
\value{
Table: UMAP analysis for analyzing RNA-Seq data.
}
\description{
UMAP analysis for analyzing RNA-Seq data.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_expression)
head(gene_expression)

data(samples_groups)
head(samples_groups)

# 3. Default parameters
res <- umap_analysis(gene_expression, samples_groups)
head(res)

}
\author{
benben-miao
}
