% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_cluster.R
\name{heatmap_cluster}
\alias{heatmap_cluster}
\title{Heatmap cluster for visualizing clustered gene expression data.}
\usage{
heatmap_cluster(
  data,
  dist_method = "euclidean",
  hc_method = "average",
  k_num = 5,
  show_rownames = FALSE,
  palette = "Spectral",
  cluster_pal = "Set1",
  gaps_col = NULL,
  angle_col = 45,
  label_size = 10,
  base_size = 12
)
}
\arguments{
\item{data}{Dataframe: gene expression dataframe with cols (samples) and rows (genes).}

\item{dist_method}{Character: distance measure method. Default: "euclidean", options: "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{hc_method}{Character: hierarchical clustering method. Default: "average", options: "ward.D", "ward.D2", "single", "complete","average" (= UPGMA), "mcquitty" (= WPGMA), "median" (= WPGMC) or "centroid" (= UPGMC).}

\item{k_num}{Numeric: the number of groups for cutting the tree. Default: 5.}

\item{show_rownames}{Logical: boolean specifying if column names are be shown. Default: FALSE, options: TRUE or FALSE.}

\item{palette}{Character: color palette used in heatmap. Default: "Spectral", options: 'Spectral', 'BrBG', 'PiYG', 'PRGn', 'PuOr', 'RdBu', 'RdGy', 'RdYlBu', 'RdYlGn'.}

\item{cluster_pal}{Character: color palette used for the cluster. Default: "Set1", options: 'Set1', 'Set2', 'Set3', 'Accent', 'Dark2', 'Paired', 'Pastel1', 'Pastel2'.}

\item{gaps_col}{Character: vector of columns indices that show where to put gaps into heatmap. Default: "NULL".}

\item{angle_col}{Numeric: angle of the column labels. Default: 45.}

\item{label_size}{Numeric: fontsize for the plot. Default: 10, min: 0.}

\item{base_size}{Numeric: base font size. Default: 12, min: 0.}
}
\value{
Plot: Heatmap cluster for visualizing clustered gene expression data.
}
\description{
Heatmap cluster for visualizing clustered gene expression data.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset gene_exp
data(gene_exp2)
head(gene_exp2)

# 3. Default parameters
heatmap_cluster(gene_exp2)

# 4. Set palette = "RdBu"
heatmap_cluster(gene_exp2, palette = "RdBu")

# 5. Set cluster_pal = "Accent"
heatmap_cluster(gene_exp2, cluster_pal = "Accent")

}
\author{
wei dong
}
