% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flower_plot.R
\name{flower_plot}
\alias{flower_plot}
\title{Flower plot for stat common and unique gene among multiple sets.}
\usage{
flower_plot(
  flower_dat,
  angle = 90,
  a = 0.5,
  b = 2,
  r = 1,
  ellipse_col_pal = "Spectral",
  circle_col = "white",
  label_text_cex = 1
)
}
\arguments{
\item{flower_dat}{Dataframe: multiple gene sets as columns.}

\item{angle}{Number: set the angle of rotation in degress. Default: 90.}

\item{a}{Number: set the radii of the ellipses along the x-axes. Default: 0.5.}

\item{b}{Number: set the radii of the ellipses along the y-axes. Default: 2.}

\item{r}{Number: set the radius of the circle. Default: 1.}

\item{ellipse_col_pal}{Character: set the color palette for filling the ellipse. Default: "Spectral", options: 'Spectral', 'Set1', 'Set2', 'Set3', 'Accent', 'Dark2', 'Paired', 'Pastel1', 'Pastel2'.}

\item{circle_col}{Character: set the color for filling the circle. Default: "white".}

\item{label_text_cex}{Number: set the label text cex. Default: 1.}
}
\value{
Plot: Flower plot for stat common and unique gene among multiple sets.
}
\description{
Flower plot for stat common and unique gene among multiple sets.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset venn_data
data(venn_data)
head(venn_data)

# 3. Default parameters
flower_plot(venn_data)

# 4. Set angle = 60
flower_plot(venn_data, angle = 60)

# 5. Set ellipse_col_pal = "Spectral"
flower_plot(venn_data, ellipse_col_pal = "Spectral")

# 6. Set a = 1, b = 2, r = 1
flower_plot(venn_data, a = 1, b = 2, r = 1, ellipse_col_pal = "Set2")

}
\author{
wei dong
}
