% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_cor_test.R
\name{boot_cor_test}
\alias{boot_cor_test}
\title{Bootstrapped correlation coefficients}
\usage{
boot_cor_test(
  x,
  y,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  method = c("pearson", "kendall", "spearman", "winsorized", "bendpercent"),
  alpha = 0.05,
  null = 0,
  R = 1999,
  ...
)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{y}{an optional (non-empty) numeric vector of data values.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{method}{a character string indicating which correlation coefficient is to be used for the test. One of "winsorized", "bendpercent","pearson", "kendall", or "spearman", can be abbreviated.}

\item{alpha}{alpha level (default = 0.05)}

\item{null}{a number indicating the null hypothesis. Default is a correlation of zero.}

\item{R}{number of bootstrap replicates}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A list with class "htest" containing the following components:
\itemize{
\item "p.value": the p-value of the test.
\item "estimate": the estimated measure of association, with name "pb", "wincor", "cor", "tau", or "rho" corresponding to the method employed.
\item "null.value": the value of the association measure under the null hypothesis.
\item "alternative": character string indicating the alternative hypothesis (the value of the input argument alternative).
\item "method": a character string indicating how the association was measured.
\item "data.name": a character string giving the names of the data.
\item "call": the matched call.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function for a bootstrap, percentile, method for correlation coefficients.
}
\details{
This function uses a percentile bootstrap methods for the confidence intervals.
The returned p-values are calculated from a re-sampled null distribution (similar to \link{boot_t_TOST}).
See \code{vignette("correlations")} for more details.

The bootstrap correlation methods in this package offer two other correlations: a Winsorized correlation and a percentage bend correlation (see Wilcox 2017).
These two can modified by adding the trim (Winsorized) or beta (percentage bend) arguments.
The default for both arguments is 0.2 but can be modified at the user's discretion.
These calculations are based on Rand Wilcox's R functions for his book (Wilcox, 2017), and adapted from their implementation in Guillaume Rousselet's R package "bootcorci".
}
\section{References}{


Wilcox, R.R. (2009) Comparing Pearson Correlations: Dealing with Heteroscedasticity and Nonnormality.
Communications in Statistics - Simulation and Computation, 38, 2220–2234.

Wilcox, R.R. (2017) Introduction to Robust Estimation and Hypothesis Testing, 4th edition. Academic Press.
}

\seealso{
Other Correlations: 
\code{\link{corsum_test}()},
\code{\link{plot_cor}()},
\code{\link{power_z_cor}()},
\code{\link{z_cor_test}()}
}
\concept{Correlations}
