% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_TL.LxTx.R
\name{calc_TL.LxTx}
\alias{calc_TL.LxTx}
\title{calculation of the Lx/Tx matrix}
\usage{
calc_TL.LxTx(object)
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): \code{TLum.Analysis} object}
}
\value{
The function provides an \linkS4class{TLum.Results} containing: \cr
 \describe{
   \item{\code{Temperatures}}{
     \link{numeric}: Vector with the temperature values.}
   \item{\code{Names}}{
     \link{character}: Vector with the curve names.}
   \item{\code{Datatype}}{
     \link{character}: Vector with the curve type.}
   \item{\code{Doses}}{
     \link{numeric}: Vector with the curve doses.}
   \item{\code{Testdoses}}{
     \link{numeric}: Vector with the curve test-doses.}
   \item{\code{Lx}}{
     Lx matrix.}
   \item{\code{Lx.error}}{
     Absolute error for the Lx matrix.}
   \item{\code{Tx}}{
     Tx matrix.}
   \item{\code{Tx.error}}{
     Absolute error for the Tx matrix}
   \item{\code{LxTx}}{
     Lx/Tx matrix.}
   \item{\code{LxTx.error}}{
     Absolute error for the Lx/Tx matrix.}
 }
}
\description{
Internal function called by \link{analyse_TL.MAAD} and \link{analyse_TL.SAR}. \cr
This function separates the Lx matrix from the Tx matrix.
Then, it estimates the Lx/Tx matrix.
It also provides a name for each of the curves. \cr
}
\details{
\bold{Warning}: This function is an internal function and should not be used except for development purposes.
 Internal functions can be heavily modified and even renamed or removed in new version of the package.
}
\author{
David Strebler, University of Cologne (Germany).
}
\references{
Aitken, M.J. (1985) Thermoluminescence Dating, Academic Press, London \cr

 Murray & Wintle (2000). Luminescence dating of quartz using an improved single-aliquot regenerative-dose protocol. Radiation Measurements, Vol.32, No.1, p.57-73. \cr
}
\seealso{
\link{analyse_TL.MAAD},
 \link{analyse_TL.SAR}.
}

