% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Analysis2TLum.Analysis.R
\name{RLum.Analysis2TLum.Analysis}
\alias{RLum.Analysis2TLum.Analysis}
\title{Convert RLum.Analysis object to an TLum.Analysis.}
\usage{
RLum.Analysis2TLum.Analysis(object, relative.error)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Analysis}} (\bold{required}): object containing the TL curves used for the ED estimation.}

\item{relative.error}{\link{numeric} (\bold{required}): Relative error of the TL signals. Generally, it is between 0.02 and 0.1.}
}
\description{
This function convert a \linkS4class{RLum.Analysis} object, created using the package'Luminescence', into a \linkS4class{TLum.Analysis} object, which will be used by this package.
The TL package is implemented to only works with its own class of object (TLum.Analysis, TLum.Analysis and TLum.Data.Curve).
}
\details{
This function use the data from the RLum.Analysis and the relative.error specified to create a absolute error matrix.
Then it create a new TLum.Analysis including all the information from the RLum.Analysis and the new absolute error matrix.
For practical reason, the TLdating package considers the error as random. It means that the systematic component of the error will be ignored.
}
\author{
David Strebler, University of Cologne (Germany), \cr David Strebler
}

