% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terr.R
\name{terr}
\alias{terr}
\title{Generate Data with T-distributed Errors}
\usage{
terr(n, nr, p, dist_type, ...)
}
\arguments{
\item{n}{Number of observations.}

\item{nr}{Number of observations with different error distribution.}

\item{p}{Number of predictors.}

\item{dist_type}{Type of distribution for the error terms.}

\item{...}{Additional parameters for specific distributions.}
}
\value{
A list containing the design matrix X, the response vector Y, and the error vector e.
}
\description{
Generate Data with T-distributed Errors
}
\examples{
set.seed(12)
n <- 1200
nr <- 200
p <- 5
data <- terr(n, nr, p, dist_type = "student_t")
print(data$X)
print(data$Y)
print(data$e)
}
