% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learnDbnStruct3dParDeg1.R
\name{learnDbnStructMo1Layer3dParDeg1_v2}
\alias{learnDbnStructMo1Layer3dParDeg1_v2}
\title{Goal: Unrolled DBN structure learning with Markov Order 1.}
\usage{
learnDbnStructMo1Layer3dParDeg1_v2(input.data.discr.3D, mi.net.adj.matrix,
  num.discr.levels, num.nodes, num.timepts, max.fanin, node.names,
  clr.algo)
}
\arguments{
\item{input.data.discr.3D}{Dimensions {1 = time points, 2 = variables, 3 = samples under the same time point}.}

\item{mi.net.adj.matrix}{Adjacency matrix of the mutual information network. Rownames and colnames should be node names.}

\item{num.discr.levels}{If input data is discretized, then number of discrete levels for each variable. Else if input data is continuous, then number of levels in which data needs to be discretized for performing the DBN structure learning.}

\item{num.nodes}{number of nodes}

\item{num.timepts}{number of timepoints}

\item{max.fanin}{maximum incoming edges in the graph}

\item{node.names}{name of the nodes}

\item{clr.algo}{clr algorithm to use}
}
\value{
Unrolled DBN adjacency matrix
}
\description{
This function is the newer version of learnDbnStructMo1Layer3dParDeg1().
The only difference is in the size of unrolled DBN adjacency matrix. In earlier version,
the size is ((V \ times T) \ times (v \ times T)) where V = number of nodes and
T = number of time points. But the size is too large when V is very large. For
e.g., when V = 4028, the function can not execute successfully even with 32 GB main
memory in grni server. In this version, the size is reduced by storing the unrolled DBN
in an adjacency list of length (T - 1). The t^{th} element in the list is
the predicted network adjacency matrix at the t^{th} time interval. Therefore, each list element
is a binary matrix of dimension (V \ times V). Hence, the total size of the unrolled DBN
adjacency list is ((T - 1) \ times (V \ times V)).
Candidate parents: The target node itself and its CLR net neighbours at immediately previous time pt.
}
