% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDataToCytoscape.R
\name{adjmxToSif}
\alias{adjmxToSif}
\title{Create a .sif file from given adjacency matrix}
\usage{
adjmxToSif(adj.mx, output.dirname = "./OUTPUT")
}
\arguments{
\item{adj.mx}{adjacency matrix that needs to be converted}

\item{output.dirname}{name of the output directory where the file will be stored}
}
\description{
Given a network adjacency matrix, creates an equivalent '.sif' file that
is readable in Cytoscape. SIF file extension stands for Simple Interaction
Format.
Ref: http://manual.cytoscape.org/en/3.4.0/Supported_Network_File_Formats.html#sif-format
E.g., if the input network adjacency matrix is as follows: (rows = src nodes, cols = tgt nodes,
(A, B) = 0 and 1 implies that the edge 'A->B' does not exist and does exist, resp.)
src\ tgt  A B C D
A         0 1 1 0
B         0 0 0 0
C         1 0 0 0
C         0 0 0 0
then the output SIF file will contain the following four lines:
A  B C
B
C  A
D
The way Cytoscape interprets each line in this SIF file is as follows:
<Source node name> <Target node1 name (if any)>  <Target node2 name (if any)> ...
Note that the values are delimited by tab.
}
