% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_cmi.R
\name{ComputeCmiPcaCmi}
\alias{ComputeCmiPcaCmi}
\title{Compute Conditional Mutual Information (CMI) the way it is done in the implementation of the PCA-CMI algo}
\usage{
ComputeCmiPcaCmi(v1, v2, vcs)
}
\arguments{
\item{v1}{random variable 1}

\item{v2}{random variable 2}

\item{vcs}{random vector 'vcs'}
}
\value{
Conditional Mutual info between 'v1' and 'v2'
}
\description{
Compute Conditional Mutual Info between random variables 'v1' and 'v2'
given random vector 'vcs'.
Therefore, when 'vcs' is NULL, this
function returns the mutual info between
random variables 'v1' and 'v2'.
The implementation of this R function
is adapted from the mutual info estimator
function used in the PCA-CMI algo [1].
The original funciton, namely 'cmi()' [2],
is written in MATLAB.
}
\examples{
ComputeCmiPcaCmi(c(3,5),c(4,2))

}
\references{
[1] Zhang X, Zhao X M, He K, et al. Inferring gene
regulatory networks from gene expression data by
path consistency algorithm based on conditional
mutual information[J]. Bioinformatics, 2012, 28(1): 98-104.
Companion website:
https://sites.google.com/site/xiujunzhangcsb/software/pca-cmi

[2] Function declaration: 'function cmiv=cmi(v1,v2,vcs)',
Source code file: http://www.comp-sysbio.org/grn/pca_cmi.m .
}
