% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeLimits}
\alias{computeLimits}
\title{Compute the Extreme Values of Birth, Death, and Persistence Across Multiple Persistence Diagrams}

\description{
Given a list of persistence diagrams, \code{computeLimits()} computes the extreme values of birth, death, and persistence across all diagrams for a specified homological dimension. Points with infinite death values are ignored.
}

\usage{
computeLimits(Dlist, homDim)
}

\arguments{
\item{Dlist}{a list of persistence diagrams, where each diagram is a matrix containing three columns representing homological dimension, birth, and death values.}
\item{homDim}{the homological dimension (0 for \eqn{H_0}, 1 for \eqn{H_1}, etc.). Rows of the diagrams are filtered based on this value.}
}

\value{
A (named) numeric vector containing:
\itemize{
\item \code{minB}: the minimum birth value across all diagrams.
\item \code{maxB}: the maximum birth value across all diagrams.
\item \code{maxD}: the maximum death value across all diagrams.
\item \code{minP}: the minimum persistence value across all diagrams.
\item \code{maxP}: the maximum persistence value across all diagrams.
}
}

\author{Umar Islambekov}

\examples{
set.seed(123)
N <- 100 # The size of point clouds
nD <- 50 # The number of persistence diagrams
Dlist <- list()
for (i in 1:nD){
  # sample N points uniformly from the unit circle and add Gaussian noise
  theta <- runif(N, min = 0, max = 2 * pi)
  X <- cbind(cos(theta), sin(theta)) + rnorm(2 * N, mean = 0, sd = 0.2)

  # Compute the persistence diagram using the Rips filtration built on top of X
  # The 'threshold' parameter specifies the maximum distance for building simplices
  Dlist[[i]] <- TDAstats::calculate_homology(X, threshold = 2)
}

# Compute the extreme values of birth, death, and persistence across 
# all 50 diagrams for homological dimension H_0
computeLimits(Dlist, homDim = 0)

# Compute the extreme values of birth, death, and persistence across 
# all 50 diagrams for homological dimension H_1
computeLimits(Dlist, homDim = 1)
}
