% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_7.R
\name{expand_cases}
\alias{expand_cases}
\title{Explode TCGA Case Identifiers from a TCGA Study}
\usage{
expand_cases(csid = "mel_tsam_liang_2017")
}
\arguments{
\item{csid}{string corresponding to a TCGA Cancer Study identifier}
}
\value{
list containing as many elements as TCGA case lists 
available for a given TCGA Study. Each element is a list containing two elements: 
\itemize{
  \item a string corresponding to the Id of the case list as defined by TCGA
  \item character vector including all case IDs corresponding to the case list
}
}
\description{
Each TCGA Study includes one or more "case lists". These are lists of 
sample/patient identifiers. All case lists of a study of interest are 
retrieved and the individual case identifiers are expanded and returned
}
\examples{
expand_cases("mel_tsam_liang_2017")

}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
