% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.boot.R
\name{clean.boot}
\alias{clean.boot}
\title{Clean Boot Directory}
\usage{
clean.boot(force = FALSE)
}
\arguments{
\item{force}{passed to \code{clean.data}, \code{clean.library}, and
\code{clean.software}.}
}
\value{
No return value, called for side effects.
}
\description{
Clean the boot directory using \code{clean.data}, \code{clean.library}, and
\code{clean.software}.
}
\note{
Instead of completely removing the \verb{boot} directory, \code{clean.data},
\code{clean.library}, and \code{clean.software} are used to clean the
\verb{boot/data}, \verb{boot/library}, and \verb{boot/library}
subdirectories. This protects the subdirectory \verb{boot/initial}, boot
scripts, and \verb{*.bib} metadata files from being accidentally deleted.
}
\examples{
\dontrun{
clean()
clean.boot()
}

}
\seealso{
\code{\link{clean}} cleans TAF directories: \verb{data}, \verb{model},
\verb{output}, and \verb{report}.

\code{\link{clean.data}} selectively removes data from \verb{boot/data}.

\code{\link{clean.library}} selectively removes packages from
\verb{boot/library}.

\code{\link{clean.software}} selectively removes software from
\verb{boot/software}.

\code{\link{TAF-package}} gives an overview of the package.
}
