% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Check_Sudoku_Design.R
\name{Check_Sudoku_Design}
\alias{Check_Sudoku_Design}
\title{Check Properties of Sudoku Designs}
\usage{
Check_Sudoku_Design(Design, Region)
}
\arguments{
\item{Design}{Give the Sudoku design in a matrix format}

\item{Region}{Provide a Region matrix corresponding to Sudoku design}
}
\value{
Design along with design parameters, C matrix (Information matrix), eigenvalues(EVs) and canonical efficiency factor (CEF) of a given Sudoku design
}
\description{
Check Properties of Sudoku Designs
}
\examples{
library(SudokuDesigns)
design<-matrix(c(1,2,3,4,3,4,1,2,2,1,4,3,4,3,2,1),nrow=4,ncol=4,byrow=TRUE)
region<-matrix(c(1,1,2,2,1,1,2,2,3,3,4,4,3,3,4,4),nrow=4,ncol=4,byrow=TRUE)
Check_Sudoku_Design(design,region)
}
