`sunrise.set` <- function(lat, long, date, timezone="UTC", 		  num.days=1){
      #this needs to be long lat#
      lat.long <- matrix(c(long, lat), nrow=1)
      day <- as.POSIXct(date, tz=timezone)
      sequence <- seq(from=day, length.out=num.days ,                   	  by="days")
      sunrise <- sunriset(lat.long, sequence,  					  direction="sunrise",
	  POSIXct=TRUE)
      sunset <- sunriset(lat.long, sequence,					  direction="sunset", POSIXct=TRUE)
      ss <- data.frame(sunrise, sunset)
      ss <- ss[,-c(1,3)]
      colnames(ss)<-c("sunrise", "sunset")
      return(ss)
}