% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zijderveld.R
\name{zijderveld}
\alias{zijderveld}
\title{Draws a Zijderveld plot}
\usage{
zijderveld(
  dec,
  inc,
  int,
  xh = "WE",
  xv = xh,
  centre = F,
  xlim = NA,
  ylim = NA,
  unit = NA,
  xlab = "",
  ylab = "",
  labels = NA,
  nlabels = 1,
  h = list(pch = 19),
  v = list(pch = 21, bg = "white"),
  f = list(pch = 21, bg = "white", cex = 1.5),
  t = list(pos = 3, offset = 0.5),
  l = list(),
  anchored = T,
  style = "branches",
  tcl = 0.2,
  orientation = TRUE,
  scientific = NA,
  decimals = 10,
  add = FALSE
)
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010). Values outside this range are corrected
by incfix().}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010). Values outside this range are corrected
by incfix().}

\item{int}{intensity of the data.}

\item{xh}{orientation of the x axis for the horizontal points: can be
'SN' or 'WE'.}

\item{xv}{orientation of the x axis for the horizontal points: can be
'SN', 'WE' or 'modified' (for the latter the horizontal projection of the
vector given by the square root of the addition of the squared horizontal
components).}

\item{centre}{logical, whether the [0,0] point should be in the centre
of the plot. Is ignored if xlim and/or ylim are defined.}

\item{xlim, ylim}{the x and y minimal limits. The actual limits can
change to keep a x/y ratio of 1.}

\item{unit}{the tick interval.}

\item{xlab, ylab}{the titles for the axes.}

\item{labels}{a character vector of labels to add to each point.}

\item{nlabels}{the number of labels to skip (for clarity).}

\item{h, v, f, t, l}{list of graphical parameters to feed the graphical
functions: h, v and f are fed to points() for the horizontal, vertical and
first points respectively; t is fed to the text() for the labels and l is
fed to lines() for the lines joining each horizontal and vertical points. See
?points, ?text and ?lines help page for the possible arguments. See
?merge_list for further information.}

\item{anchored}{logical, whether the lines should be anchored to the
[0,0] point.}

\item{style}{the style of the plot: 'branches', 'box0', 'box1', or
'box2'. The boxes are advised when zooming using xlim and/or ylim.}

\item{tcl}{The length of tick marks (see par() help page).}

\item{orientation}{logical, whether to add captions indicating the
orientation of the plot.}

\item{scientific}{logical or NA, whether have scientific notation
(e.g. -1.0E-06) or not (e.g. 0.00015). If NA, R will be left only judge.}

\item{decimals}{the number of decimals if scientific is T or F. Having
not enough decimals can lead to override the unit parameter, but the tick
labels will be correctly aligned.}

\item{add}{logical, whether to add the plot to an existing plot.}
}
\description{
Draws a Zijderveld plot: it projects 3D points (having
declination, inclination and intensity) in 2D, horizontally and vertically.
}
\details{
By default horizontal projection is made of black points, vertical
of white points.
}
\examples{
zd <- zeq_example

ori <- par()$mfrow

par(mfrow = c(1,2))

zijderveld(dec = zd$Dec, inc = zd$Inc, int = zd$Int,
           xh = "WE", unit = 10^-5)

zijderveld(dec = zd$Dec, inc = zd$Inc, int = zd$Int,
           style = "box1", scientific = FALSE, decimals = 5,
           labels = zd$Treat, nlabels = 2)

par(mfrow = ori)

}
\references{
\itemize{
  \item Tauxe, L., 2010. Essentials of Paleomagnetism. University of
  California Press.
  }
}
\seealso{
\code{\link{earnet}}
}
