% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_train.R
\name{filter_train}
\alias{filter_train}
\title{Filter: Train Filter Model}
\usage{
filter_train(Y, A, X, family = "gaussian", filter, hyper = NULL, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{family}{Outcome type ("gaussian", "binomial", "survival"). Default is "gaussian".}

\item{filter}{Filter function. Potentially reduces covariate space, 
(Y, A, X) ==> (Y, A, Xstar).}

\item{hyper}{Hyper-parameters for the filter model (must be list). Default is NULL.}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained filter model and vector of variable names that pass the filter. 

 \itemize{
  \item mod - trained model
  \item filter.vars - Variables that remain after filtering (could be all)
}
}
\description{
Wrapper function to train a filter model. Options include elastic net (glmnet) and random forest based 
variable importance (ranger). Used directly in PRISM.
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Fit ple_ranger directly (treatment-specific ranger models) #
mod1 = filter_train(Y, A, X, filter="filter_glmnet")
mod1$filter.vars

mod2 = filter_train(Y, A, X, filter="filter_ranger")
mod2$filter.vars

}


}
\seealso{
\code{\link{PRISM}}
}
