% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e2e_plot_edrivers.R
\name{e2e_plot_edrivers}
\alias{e2e_plot_edrivers}
\title{Plot climatological year of environmental driving data.}
\usage{
e2e_plot_edrivers(model)
}
\arguments{
\item{model}{R-list object defining the model configuration compiled by the e2e_read() function.}
}
\value{
Graphical display in a new graphics window. Does not return any data object since the data plotted are all available as input csv files.
}
\description{
Multi-panel time series plots of climatological annual cycles of driving data as provided in the input csv files.
}
\details{
The function plots a multi-panel page of time series plots of monthly values of the environmental driving data for the model.

Units for the plotted variables are as follows:

\itemize{
  \item Sea surface irradiance: uE/m2/d
  \item Suspended particulate matter: g/m3
  \item Temperature: deg-C
  \item Vertical diffusivity gradient: m/d (derived from the vertical diffusivity (m2/s) and mixing length scale (m))
  \item External inflows: m3 per m2 sea surface of model domain (derived from proportion input per layer volume, layer thicknesses and areas)
  \item River discharge: m3 per m2 sea surface of model domain (derived from proportion input to inshore volume, and inshore layer thickness and area)
  \item Inshore significant wave height: m
  \item Proportion of seabed disturbed: /d (aggregated over the three sediment classes in each zone)
  \item External boundary nitrate concentration: mMN/m3
  \item External boundary ammonia concentration: mMN/m3
  \item External boundary phytoplankton concentration: mMN/m3
  \item External boundary detritus concentration: mMN/m3
  \item River nitrate concentration: mMN/m3
  \item River ammonia concentration: mMN/m3
  \item Atmospheric nitrate deposition flux: mMN/m2/d
  \item Atmospheric ammonia deposition flux: mMN/m2/d
}
}
\examples{
# Load the 2003-2013 version of the North Sea model supplied with the package:
    model <- e2e_read("North_Sea", "2003-2013")
# Plot the annual cyles of driving data
    e2e_plot_edrivers(model)

# Direct the graphics output to a pdf file ... 
# or jpeg("plot.jpg"), png("plot.png")
    pdf(file.path(tempdir(), "plot.pdf"),width=8,height=6)
    e2e_plot_edrivers(model)
    dev.off()

}
\seealso{
\code{\link{e2e_read}}, \code{\link{e2e_run}}, \code{\link{e2e_plot_fdrivers}}
}
