% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steinertree.R
\name{steinertree}
\alias{steinertree}
\title{Find Steiner Tree}
\usage{
steinertree(type, repeattimes = 70, optimize = TRUE, terminals,
            graph, color = TRUE, merge = FALSE)
}
\arguments{
\item{type}{a character scalar, which indicates type of algorithms to perform. Can be
"EXA", "SP", "KB", "RSP", "SPM" or "ASP".}

\item{repeattimes}{a numeric scalar to specify "RSP" algorithm; number of times the optimization procedure is repeated.}

\item{optimize}{a logical scalar to specify all algorithms except "EXA"; if TRUE, an optimization of the resultant
steiner tree is performed, otherwise nothing is done.}

\item{terminals}{a numeric or character vector with ids of terminals or a character vector with names of vertices 
(only if vertices have name attribute).}

\item{graph}{an igraph graph; should be undirected, otherwise it is converted to undirected.}

\item{color}{a logical scalar; whether to return an original graph with terminals colored in red and
steiner nodes colored in green. Note, if several trees will be found, steiner nodes from all trees
are colored in green.}

\item{merge}{a logical scalar to specify "EXA" and "SPM" algorithms; if several trees will be found, whether to return
a list with trees or merge them}
}
\value{
(color = FALSE) Returns a list first element of which is a steiner tree (or a graph of merged trees).
        If several steiner trees are found, return a list, each element of which is a steiner tree.
         
        (color = TRUE) Returns a list, first element of which is a colored original graph and second element is
        a steiner tree (or a graph of merged trees) or list of steiner trees.
}
\description{
A set of functions for finding Steiner Tree. Includes both exact and heuristic approaches.
}
\details{
Firstly, if input graph doesn't have name attribute, one is created, otherwise realname attribute is created
         and names is stored in it. In its turn name attribute will contain character ids of vertices. Further,
         if the terminals variable has character type and it can not be converted to numeric type, the terminals are searched
         among realnames. If the terminals variable has numeric type or it can be converted to numeric type,
         it is considered, ids of vertices is passed.
         
         Note, that before algorithm is running all vertices will be colored in yellow and terminals will be colored in red.
}
\examples{
steinertree(type = "RSP", optimize = FALSE,
            terminals = c(1, 3),
            graph = graph("Cubical"),
            color = TRUE, merge = FALSE)

}
\references{
1. Path heuristic and Original path heuristic ,Section 4.1.3 of the book "The Steiner tree Problem",
               Petter,L,Hammer
               
            2. "An approximate solution for the Steiner problem in graphs", H Takahashi, A Matsuyama
            
            3. F K. Hwang, D S. Richards and P Winter, "The steiner tree Problem", Kruskal-Based Heuristic
               Section 4.1.4, ISBN: 978-0-444-89098-6
               
            4. Afshin Sadeghi and Holger Froehlich, "Steiner tree methods for optimal sub-network
               identification: an empirical study", BMC Bioinformatics 2013 14:144
               
            5. F K. Hwang, D S. Richards and P Winter, "The steiner tree Problem", Kruskal-Based Heuristic Section
               4.1.4, The Optimal solution for steiner trees on networks, ISBN: 978-0-444-89098-6.
}
\seealso{
\code{\link{generate_st_samples}}
}
