% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mape.R
\name{mape}
\alias{mape}
\title{Compute mean absolute percentage error}
\usage{
mape(y, yhat)
}
\arguments{
\item{y}{actual linear response}

\item{yhat}{predicted linear response}
}
\value{
mean absolute percentage error
}
\description{
Takes in actual and predicted linear response, and returns MAPE value
}
\details{
\code{mape} calculates the mean absolute percentage error in a predicted linear
 response.
}
\examples{
# A 'data.frame' with y and yhat
 df <- data.frame(y = c(1.5, 2, 3.2),
                  yhat = c(3.4, 2.2, 2.7))

# Compute mape
MAPE <- mape(y = df[, 'y'], yhat = df[, 'yhat'])
}
\author{
Akash Jain
}
\seealso{
\code{\link{actvspred}}, \code{\link{splitdata}}
}

