% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotforStMoMo.R
\name{plot.forStMoMo}
\alias{plot.forStMoMo}
\title{Plot a forecast from a Stochastic Mortality Model}
\usage{
\method{plot}{forStMoMo}(x, nCol = 2, parametricbx = TRUE, only.kt = FALSE,
 only.gc = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{"forStMoMo"} with the forecast
of a stochastic mortality model.}

\item{nCol}{number of columns to use in the plot.}

\item{parametricbx}{if \code{FALSE} parametric age-modulating terms,
which don't need to be estimated, are not plotted.}

\item{only.kt}{If \code{TRUE} only the period indexes of the model are
plotted.}

\item{only.gc}{If \code{TRUE} only the cohort index of the model is
plotted. This argument is ignored if \code{only.kt} is \code{TRUE}.}

\item{...}{additional arguments to control graphical appearance.
See \code{\link[graphics]{plot}}.}
}
\description{
Plot a forecasted Stochastic Mortality Model of class \code{"forStMoMo"}.
}
\examples{
wxt <- genWeightMat(55:89,  EWMaleData$years, clip = 3)
APCfit <- fit(apc(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext,
              ages = EWMaleData$ages, years = EWMaleData$years,
              ages.fit = 55:89, wxt = wxt)
APCfor <- forecast(APCfit)
plot(APCfor)
plot(APCfor, parametricbx = FALSE, nCol = 3)
plot(APCfor, only.kt = TRUE)
plot(APCfor, only.gc = TRUE, lwd = 2)
}
\seealso{
\code{\link{plot.fitStMoMo}}
}

