% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseVFC.R
\name{norm_vecs}
\alias{norm_vecs}
\title{Normalize (a Matrix of) Vectors}
\usage{
norm_vecs(x)
}
\arguments{
\item{x}{The matrix to be normalized. Each row of \code{x} represent a vector.}
}
\value{
The normalized matrix with an attribution \code{scale}, which is the scale factor used for normalization.
}
\description{
Normalize the data so that the mean of the vectors is \strong{0} and the variance of the vectors is 1. Here the variance of vectors is calculated by interpreting the deviation as the Euclidean distance, which means the trace of the (population) covariance matrix is 1.
}
\examples{
norm_vecs(matrix(rep(1, 100), nrow = 2))
}
