% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib.R
\docType{methods}
\name{spark.gbt}
\alias{spark.gbt}
\alias{spark.gbt}
\alias{spark.gbt,SparkDataFrame,formula-method}
\alias{predict,GBTRegressionModel-method}
\alias{predict,GBTClassificationModel-method}
\alias{write.ml,GBTRegressionModel,character-method}
\alias{write.ml,GBTClassificationModel,character-method}
\alias{summary,GBTRegressionModel-method}
\alias{summary,GBTClassificationModel-method}
\alias{print.summary.GBTRegressionModel}
\alias{print.summary.GBTClassificationModel}
\title{Gradient Boosted Tree Model for Regression and Classification}
\usage{
spark.gbt(data, formula, ...)

\S4method{spark.gbt}{SparkDataFrame,formula}(data, formula,
  type = c("regression", "classification"), maxDepth = 5, maxBins = 32,
  maxIter = 20, stepSize = 0.1, lossType = NULL, seed = NULL,
  subsamplingRate = 1, minInstancesPerNode = 1, minInfoGain = 0,
  checkpointInterval = 10, maxMemoryInMB = 256, cacheNodeIds = FALSE)

\S4method{predict}{GBTRegressionModel}(object, newData)

\S4method{predict}{GBTClassificationModel}(object, newData)

\S4method{write.ml}{GBTRegressionModel,character}(object, path,
  overwrite = FALSE)

\S4method{write.ml}{GBTClassificationModel,character}(object, path,
  overwrite = FALSE)

\S4method{summary}{GBTRegressionModel}(object)

\S4method{summary}{GBTClassificationModel}(object)

\method{print}{summary.GBTRegressionModel}(x, ...)

\method{print}{summary.GBTClassificationModel}(x, ...)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{type}{type of model, one of "regression" or "classification", to fit}

\item{maxDepth}{Maximum depth of the tree (>= 0).}

\item{maxBins}{Maximum number of bins used for discretizing continuous features and for choosing
how to split on features at each node. More bins give higher granularity. Must be
>= 2 and >= number of categories in any categorical feature.}

\item{maxIter}{Param for maximum number of iterations (>= 0).}

\item{stepSize}{Param for Step size to be used for each iteration of optimization.}

\item{lossType}{Loss function which GBT tries to minimize.
For classification, must be "logistic". For regression, must be one of
"squared" (L2) and "absolute" (L1), default is "squared".}

\item{seed}{integer seed for random number generation.}

\item{subsamplingRate}{Fraction of the training data used for learning each decision tree, in
range (0, 1].}

\item{minInstancesPerNode}{Minimum number of instances each child must have after split. If a
split causes the left or right child to have fewer than
minInstancesPerNode, the split will be discarded as invalid. Should be
>= 1.}

\item{minInfoGain}{Minimum information gain for a split to be considered at a tree node.}

\item{checkpointInterval}{Param for set checkpoint interval (>= 1) or disable checkpoint (-1).}

\item{maxMemoryInMB}{Maximum memory in MB allocated to histogram aggregation.}

\item{cacheNodeIds}{If FALSE, the algorithm will pass trees to executors to match instances with
nodes. If TRUE, the algorithm will cache node IDs for each instance. Caching
can speed up training of deeper trees. Users can set how often should the
cache be checkpointed or disable it by setting checkpointInterval.}

\item{object}{A fitted Gradient Boosted Tree regression model or classification model.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}

\item{x}{summary object of Gradient Boosted Tree regression model or classification model
returned by \code{summary}.}
}
\value{
\code{spark.gbt} returns a fitted Gradient Boosted Tree model.

\code{predict} returns a SparkDataFrame containing predicted labeled in a column named
        "prediction".

\code{summary} returns summary information of the fitted model, which is a list.
        The list of components includes \code{formula} (formula),
        \code{numFeatures} (number of features), \code{features} (list of features),
        \code{featureImportances} (feature importances), \code{numTrees} (number of trees),
        and \code{treeWeights} (tree weights).
}
\description{
\code{spark.gbt} fits a Gradient Boosted Tree Regression model or Classification model on a
SparkDataFrame. Users can call \code{summary} to get a summary of the fitted
Gradient Boosted Tree model, \code{predict} to make predictions on new data, and
\code{write.ml}/\code{read.ml} to save/load fitted models.
For more details, see
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#gradient-boosted-tree-regression}{
GBT Regression} and
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#gradient-boosted-tree-classifier}{
GBT Classification}
}
\note{
spark.gbt since 2.1.0

predict(GBTRegressionModel) since 2.1.0

predict(GBTClassificationModel) since 2.1.0

write.ml(GBTRegressionModel, character) since 2.1.0

write.ml(GBTClassificationModel, character) since 2.1.0

summary(GBTRegressionModel) since 2.1.0

summary(GBTClassificationModel) since 2.1.0

print.summary.GBTRegressionModel since 2.1.0

print.summary.GBTClassificationModel since 2.1.0
}
\examples{
\dontrun{
# fit a Gradient Boosted Tree Regression Model
df <- createDataFrame(longley)
model <- spark.gbt(df, Employed ~ ., type = "regression", maxDepth = 5, maxBins = 16)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)

# fit a Gradient Boosted Tree Classification Model
# label must be binary - Only binary classification is supported for GBT.
df <- createDataFrame(iris[iris$Species != "virginica", ])
model <- spark.gbt(df, Species ~ Petal_Length + Petal_Width, "classification")

# numeric label is also supported
iris2 <- iris[iris$Species != "virginica", ]
iris2$NumericSpecies <- ifelse(iris2$Species == "setosa", 0, 1)
df <- createDataFrame(iris2)
model <- spark.gbt(df, NumericSpecies ~ ., type = "classification")
}
}
