% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib.R
\docType{methods}
\name{glm}
\alias{glm}
\alias{glm,formula,ANY,SparkDataFrame-method}
\title{Generalized Linear Models (R-compliant)}
\usage{
glm(formula, family = gaussian, data, weights, subset, na.action,
  start = NULL, etastart, mustart, offset, control = list(...),
  model = TRUE, method = "glm.fit", x = FALSE, y = TRUE,
  contrasts = NULL, ...)

\S4method{glm}{formula,ANY,SparkDataFrame}(formula, family = gaussian, data,
  epsilon = 1e-06, maxit = 25, weightCol = NULL)
}
\arguments{
\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', '.', ':', '+', and '-'.}

\item{family}{a description of the error distribution and link function to be used in the model.
This can be a character string naming a family function, a family function or
the result of a call to a family function. Refer R family at
\url{https://stat.ethz.ch/R-manual/R-devel/library/stats/html/family.html}.
Currently these families are supported: \code{binomial}, \code{gaussian},
\code{Gamma}, and \code{poisson}.}

\item{data}{a SparkDataFrame or R's glm data for training.}

\item{weights}{an optional vector of \sQuote{prior weights} to be used
    in the fitting process.  Should be \code{NULL} or a numeric vector.}

\item{subset}{an optional vector specifying a subset of observations
    to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.  The default is set by
    the \code{na.action} setting of \code{\link{options}}, and is
    \code{\link{na.fail}} if that is unset.  The \sQuote{factory-fresh}
    default is \code{\link{na.omit}}.  Another possible value is
    \code{NULL}, no action.  Value \code{\link{na.exclude}} can be useful.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{etastart}{starting values for the linear predictor.}

\item{mustart}{starting values for the vector of means.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector of length equal to
    the number of cases.  One or more \code{\link{offset}} terms can be
    included in the formula instead or as well, and if more than one is
    specified their sum is used.  See \code{\link{model.offset}}.}

\item{control}{a list of parameters for controlling the fitting
    process.  For \code{glm.fit} this is passed to
    \code{\link{glm.control}}.}

\item{model}{a logical value indicating whether \emph{model frame}
    should be included as a component of the returned value.}

\item{method}{the method to be used in fitting the model.  The default
    method \code{"glm.fit"} uses iteratively reweighted least squares
    (IWLS): the alternative \code{"model.frame"} returns the model frame
    and does no fitting.

    User-supplied fitting functions can be supplied either as a function
    or a character string naming a function, with a function which takes
    the same arguments as \code{glm.fit}.  If specified as a character
    string it is looked up from within the \pkg{stats} namespace.
  }

\item{x, y}{For \code{glm}: logical values indicating whether the response vector
and model matrix used in the fitting process should be returned as
components of the returned value.}

\item{contrasts}{an optional list. See the \code{contrasts.arg}
    of \code{model.matrix.default}.}

\item{...}{
    For \code{glm}: arguments to be used to form the default
    \code{control} argument if it is not supplied directly.

    For \code{weights}: further arguments passed to or from other methods.
  }

\item{epsilon}{positive convergence tolerance of iterations.}

\item{maxit}{integer giving the maximal number of IRLS iterations.}

\item{weightCol}{the weight column name. If this is not set or \code{NULL}, we treat all instance
weights as 1.0.}
}
\value{
\code{glm} returns a fitted generalized linear model.
}
\description{
Fits a generalized linear model, similarly to R's glm().
}
\note{
glm since 1.5.0
}
\examples{
\dontrun{
sparkR.session()
data(iris)
df <- createDataFrame(iris)
model <- glm(Sepal_Length ~ Sepal_Width, df, family = "gaussian")
summary(model)
}
}
\seealso{
\link{spark.glm}
}
