% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{params}
\alias{checkpointFile}
\alias{checkpointFile,.simList-method}
\alias{checkpointFile<-}
\alias{checkpointFile<-,.simList-method}
\alias{checkpointInterval}
\alias{checkpointInterval,.simList-method}
\alias{checkpointInterval<-}
\alias{checkpointInterval<-,.simList-method}
\alias{globals}
\alias{globals,.simList-method}
\alias{globals<-}
\alias{globals<-,.simList-method}
\alias{params}
\alias{params,.simList-method}
\alias{params<-}
\alias{params<-,.simList-method}
\alias{progressInterval}
\alias{progressInterval,.simList-method}
\alias{progressInterval<-}
\alias{progressInterval<-,.simList-method}
\alias{progressType}
\alias{progressType,.simList-method}
\alias{progressType<-}
\alias{progressType<-,.simList-method}
\alias{simList-accessors-params}
\title{Get and set simulation parameters.}
\usage{
params(object)

\S4method{params}{.simList}(object)

params(object) <- value

\S4method{params}{.simList}(object) <- value

globals(object)

\S4method{globals}{.simList}(object)

globals(object) <- value

\S4method{globals}{.simList}(object) <- value

checkpointFile(object)

\S4method{checkpointFile}{.simList}(object)

checkpointFile(object) <- value

\S4method{checkpointFile}{.simList}(object) <- value

checkpointInterval(object)

\S4method{checkpointInterval}{.simList}(object)

checkpointInterval(object) <- value

\S4method{checkpointInterval}{.simList}(object) <- value

progressInterval(object)

\S4method{progressInterval}{.simList}(object)

progressInterval(object) <- value

\S4method{progressInterval}{.simList}(object) <- value

progressType(object)

\S4method{progressType}{.simList}(object)

progressType(object) <- value

\S4method{progressType}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{params} slot of a \code{simList} object
and its elements.
Additonal methods are provided to access core module and global parameters:
Commonly used
\tabular{ll}{
   \code{globals} \tab List of global simulation parameters.\cr
   \code{params} \tab Nested list of all simulation parameters.\cr
}
Advanced use
\tabular{lll}{
   Accessor method \tab Module \tab Description \cr
   \code{checkpointFile} \tab \code{.checkpoint} \tab Name of the checkpoint file. (advanced)\cr
   \code{checkpointInterval} \tab \code{.checkpoint} \tab The simulation checkpoint interval. (advanced)\cr
   \code{progressType} \tab \code{.progress} \tab Type of graphical progress bar used. (advanced)\cr
   \code{progressInterval} \tab \code{.progress} \tab Interval for the progress bar. (advanced)\cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.

Progress Bar:
Progress type can be "text", "graphical" or "shiny".
Progress interval can be a numeric.
These both can get set by passing a
\code{.progress=list(type="graphical", interval=1)} into the
simInit call. See examples
}
\examples{
\dontrun{
mySim <- simInit(times=list(start=0.0, end=100.0),
                 params=list(.globals=list(stackName="landscape"),
                             .progress=list(type="text", interval=10),
                             .checkpoint = list(interval = 10, file = "chkpnt.RData")),
                 modules=list("randomLandscapes"),
                 paths=list(modulePath=system.file("sampleModules", package="SpaDES")))

# progress bar
progressType(mySim) # "text"
progressInterval(mySim) # 10

# parameters
params(mySim) # returns all parameters in all modules
              # including .global, .progress, .checkpoint
globals(mySim) # returns only global parameters

# checkpoint
checkpointFile(mySim) # returns the name of the checkpoint file
                      # In this example, "chkpnt.RData"
checkpointInterval(mySim) # 10
}
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-inout}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-objects}},
         \code{\link{simList-accessors-paths}},
         \code{\link{simList-accessors-times}}.
}

