% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{inputs}
\alias{inputArgs}
\alias{inputArgs,.simList-method}
\alias{inputArgs<-}
\alias{inputArgs<-,.simList-method}
\alias{inputs}
\alias{inputs,.simList-method}
\alias{inputs<-}
\alias{inputs<-,.simList-method}
\alias{outputArgs}
\alias{outputArgs,.simList-method}
\alias{outputArgs<-}
\alias{outputArgs<-,.simList-method}
\alias{outputs}
\alias{outputs,.simList-method}
\alias{outputs<-}
\alias{outputs<-,.simList-method}
\alias{simList-accessors-inout}
\title{Inputs and outputs}
\usage{
inputs(object)

\S4method{inputs}{.simList}(object)

inputs(object) <- value

\S4method{inputs}{.simList}(object) <- value

outputs(object)

\S4method{outputs}{.simList}(object)

outputs(object) <- value

\S4method{outputs}{.simList}(object) <- value

inputArgs(object)

\S4method{inputArgs}{.simList}(object)

inputArgs(object) <- value

\S4method{inputArgs}{.simList}(object) <- value

outputArgs(object)

\S4method{outputArgs}{.simList}(object)

outputArgs(object) <- value

\S4method{outputArgs}{.simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{inputs} and \code{outputs} slots in a
\code{simList} object.

\code{inputArgs} and \code{outputArgs} are ways to specify any
arguments that are needed for file loading and file saving. This
is still somewhat experimental.
}
\details{
These functions are one of two mechanisms to add the information about which
input files to load in a \code{spades} call and the information about which
output files to save.
The other way is to pass them as arguments to a \code{simInit} call.

Currently, only get and set methods are defined. Subset methods are not.

\code{inputs} accepts a data.frame, with 6 columns.
Currently, only one is required.
See the modules vignette for more details (\code{browseVignettes("SpaDES")}).

Columns are \code{objectName} (required, character),
\code{file} (character),
\code{fun} (character),
\code{package} (character),
\code{interval} (numeric),
and \code{loadTime} (numeric).

\code{outputs} accepts a data.frame, with 5 columns.
Currently, only one is required.
See the modules vignette for more details (\code{browseVignettes("SpaDES")}).

Columns are: \code{objectName} (character, required),
\code{file} (character),
\code{fun} (character),
\code{package} (character),
and \code{saveTime} (numeric).
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-events}},
         \code{\link{simList-accessors-objects}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-paths}},
         \code{\link{simList-accessors-times}}.
}

