% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood.R
\name{cirSpecialQuick}
\alias{cirSpecialQuick}
\alias{.cirSpecialQuick}
\title{This is a very fast version of \code{cir} with \code{allowOverlap = TRUE},
\code{allowDuplicates = FALSE}, \code{returnIndices = TRUE}, \code{returnDistances = TRUE}, and
\code{includeBehavior = "excludePixels"}.
It is used inside \code{spread2}, when asymmetry is active.
The basic algorithm is to run \code{cir} just once, then add to the x,y coordinates of every locus.}
\usage{
.cirSpecialQuick(landscape, loci, maxRadius, minRadius)
}
\arguments{
\item{landscape}{Raster on which the circles are built.}

\item{loci}{Numeric. An alternative to \code{coords}. These are the indices on
\code{landscape} to initiate this function. See \code{coords}. Default is one
point in centre of \code{landscape}..}

\item{maxRadius}{Numeric vector of length 1 or same length as coords}

\item{minRadius}{Numeric vector of length 1 or same length as \code{coords}. Default is
\code{maxRadius}, meaning return all cells that are touched
by the narrow ring at that exact radius. If smaller than \code{maxRadius},
then this will create a buffer or donut or ring.}
}
\description{
This is a very fast version of \code{cir} with \code{allowOverlap = TRUE},
\code{allowDuplicates = FALSE}, \code{returnIndices = TRUE}, \code{returnDistances = TRUE}, and
\code{includeBehavior = "excludePixels"}.
It is used inside \code{spread2}, when asymmetry is active.
The basic algorithm is to run \code{cir} just once, then add to the x,y coordinates of every locus.
}
