% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\name{paramCheckOtherMods}
\alias{paramCheckOtherMods}
\title{Test and update a parameter against same parameter in other modules}
\usage{
paramCheckOtherMods(
  sim,
  paramToCheck,
  moduleToUse = "all",
  ifSetButDifferent = c("error", "warning", "message", "silent")
)
}
\arguments{
\item{sim}{A simList}

\item{paramToCheck}{A character string, length one, of a parameter name to
check and compare between the current module and one or more or all others}

\item{moduleToUse}{A character vector of module names to check against. This can be
\code{"all"} which will compare against all other modules.}

\item{ifSetButDifferent}{A character string indicating whether to \code{"error"}
the default, or send a \code{"warning"}, \code{message} or just silently continue
(any other value).}
}
\value{
If the value of the \code{paramToCheck} in the current module is either \code{NULL} or
\code{"default"}, and there is only one other value across all modules named in \code{moduleToUse},
then this will return a character string with the value of the single parameter value
in the other module(s). It will return the current value if there are no other modules
with the same parameter.

It is considered a "fail" under several conditions:
\enumerate{
\item current module has a value that is not \code{NULL} or \code{"default"} and another module
has a different value;
\item there is more than one value for the \code{paramToCheck} in the other modules,
so it is ambiguous which one to return.
}

\code{} either the current module is different than other modules,
unless it is "default" or NULL.
}
\description{
This function is intended to be part of module code and will test whether
the value of a parameter within the current module matches the value of the
same parameter in other modules. This is a test for parameters that might expect
to be part of a \code{params = list(.globals = list(someParam = "test"))} passed
to the \code{simInit}
}
