% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSoup.R
\name{estimateSoup}
\alias{estimateSoup}
\title{Get expression profile of soup}
\usage{
estimateSoup(sc, soupRange = c(0, 100), keepDroplets = FALSE)
}
\arguments{
\item{sc}{A \code{SoupChannel} object.}

\item{soupRange}{Droplets with total UMI count in this range (excluding endpoints) are used to estimate soup.}

\item{keepDroplets}{Storing the full table of counts for all droplets uses a lot of space and is really only used to estimate the soup profile.  Therefore, it is dropped after the soup profile has been estimated unless this is set to \code{TRUE}.}
}
\value{
A modified version of \code{sc} with an extra \code{soupProfile} entry containing a data.frame with the soup profile and confidence limits for all genes.
}
\description{
This is usually called by \code{\link{SoupChannel}}, rather than directly by the user.  Uses the empty droplets in the range provided to calculate the expression profile of the soup under the assumption that these droplets only contain background.
}
\examples{
#Load droplet and count tables
tod = Seurat::Read10X(system.file('extdata','toyData','raw_gene_bc_matrices','GRCh38',
                                  package='SoupX'))
toc = Seurat::Read10X(system.file('extdata','toyData','filtered_gene_bc_matrices','GRCh38',
                                  package='SoupX'))
#Suppress calculation of soup profile automatically on load
sc = SoupChannel(tod,toc,calcSoupProfile=FALSE)
#Retain table of droplets
sc = estimateSoup(sc,keepDroplets=TRUE)
#Or use non-default values
sc = estimateSoup(sc,soupRange=c(60,100))
}
