% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitTime.R
\name{transitTime}
\alias{transitTime}
\title{Transit times for compartment models}
\usage{
transitTime(A, u, a = seq(0, 100), q = c(0.05, 0.5, 0.95))
}
\arguments{
\item{A}{A constant compartmental square matrix with cycling rates in the
diagonal and transfer rates in the off-diagonal.}

\item{u}{A one-column matrix defining the amount of inputs per compartment.}

\item{a}{A sequence of ages to calculate density functions}

\item{q}{Vector of probabilities to calculate quantiles of the transit time
distribution}
}
\value{
A list with 3 objects: mean transit time, transit time density
distribution, and quantiles.
}
\description{
Computes the density distribution and mean for the transit time of a
constant compartmental model
}
\seealso{
\code{\link{systemAge}}
}
