% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateEgoNetwork.R
\name{CreateEgoNetwork}
\alias{CreateEgoNetwork}
\title{Note: this function is DEPRECATED and will be removed in a future release.
Please use the \code{Create} function}
\usage{
CreateEgoNetwork(dataSource, username, userid, verbose, degreeEgoNet,
  writeToFile, waitForRateLimit, getFollows)
}
\arguments{
\item{dataSource}{character string, specifying which data source. Currently
only "instagram" (default).}

\item{username}{character vector, specifying a set of usernames who will be
the 'ego' nodes for the network generation.}

\item{userid}{numeric vector, specifying a set of user ids who will be the
'ego' nodes for the network generation. If usernames are already specified,
this argument is ignored.}

\item{verbose}{logical. If \code{TRUE} then this function will output
runtime information to the console as it computes. Useful diagnostic tool
for long computations. Default is \code{FALSE}.}

\item{degreeEgoNet}{Numeric, the 'order' or 'degree' of the ego-network to
create (1 is default). 1 = ego + alters. 2 = ego + alters + alters of
alters.}

\item{writeToFile}{logical. If \code{TRUE} then the network is saved to file
in current working directory (GRAPHML format), with filename denoting the
current date/time and the type of network.}

\item{waitForRateLimit}{logical. If \code{TRUE} then it will try to observe
the API rate limit by ensuring that no more than 5000 API calls are made per
hour (the current rate limit). If more than 5000 calls are made within a 60
minute window, then all operates will suspend for 60 minutes, and resume
afterwards. Note: API calls are only tracked within the scope of this
function.}

\item{getFollows}{Logical, if TRUE (default), also collect who each 'ego'
node itself follows (i.e. not just the followers of ego), and integrate
these data into the ego network.}
}
\value{
An igraph graph object, with directed and weighted edges.
}
\description{
Create 'ego' networks from social media data
}
\details{
This function creates 'ego' networks from social media data (currently only
Instagram). The networks are igraph objects. The user provides a character
vector of usernames, and the function collects data about the 'followers' of
the users, with options to also collect data about who each user 'follows'.
It also provides the ability to specify the 'degree' of the egonet (also
sometimes known as the order), currently for 1-degree (ego + alters) or
2-degree (ego + alters + alters of alters of ego).

This function creates a (weighted and directed) 'ego' network from a given
set of seed users (the ego nodes).

The resulting network is an igraph graph object.

Note! The network size can become extremely large very quickly, depending on
the arguments the user provides to this function. For example, specifying
`degreeEgoNet=2` and `getFollows=TRUE` can generate very large networks from
just a small number of ego users (even just 3 or 4 ego nodes).
}
\note{
Currently, not all data sources in SocialMediaLab can be used for
creating ego networks. Currently only Instagram is implemented.
}
\examples{

\dontrun{
  ## Use your own values for myAppID and myAppSecret
  myAppID <- "123456789098765"
  myAppSecret <- "abc123abc123abc123abc123abc123ab"

  # Authenticate with the Instagram API using `AuthenticateWithInstagramAPI`
  instagram_oauth_token <- AuthenticateWithInstagramAPI(appID=app_id, appSecret=app_secret,
    useCachedToken=TRUE)

  myUsernames <- c("senjohnmccain","obama")

  g_ego_network <- CreateEgoNetwork(username=myUsernames,verbose=TRUE,degreeEgoNet=1,
    writeToFile=FALSE,waitForRateLimit=TRUE,getFollows=FALSE)

  # Description of actor network
  g_ego_network
}

}
\author{
Timothy Graham <timothy.graham3@uq.net.au> & Robert Ackland
<robert.ackland@anu.edu.au>
}
\seealso{
See \code{CollectDataYoutube} and \code{CollectDataTwitter} to
collect data sources for creating actor networks in SocialMediaLab.
}
\keyword{SNA}
\keyword{igraph}
\keyword{instagram}
\keyword{media}
\keyword{network}
\keyword{social}
\keyword{unimodal}

