% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py.load.R
\name{py.load}
\alias{py.load}
\title{Reads and executes Python code from a file}
\usage{
py.load(file, stopOnException = TRUE)
}
\arguments{
\item{file}{a connection or file name that will be passed to \code{readLines} to
read the Python code in the file}

\item{stopOnException}{logical value indicating whether to check or not to
call \code{stop} if a Python exception occurs}
}
\value{
if \code{stopOnException} is \code{FALSE}, invisibly returns a string
representation of any raised Python exceptions or NULL if none occur.
}
\description{
This function runs Python code contained in a file. This is basically
a convenience function that is the equivalent of \code{py.exec(readLines(file))}.
}
\details{
For better maintainability, it might be worth investigating concentrating
more complex Python code that needs to be called from R into proper packages
that can be installed using \code{pip} and loaded with 
\code{py.exec("import package_name")}.
}

