% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_categorical.R
\name{ExpCatStat}
\alias{ExpCatStat}
\title{Function provides summary statistics for all character or categorical columns in the dataframe}
\usage{
ExpCatStat(data,Target=NULL,result=c("Stat","IV"),clim=10,nlim=10,bins=10,
Pclass=NULL,plot=FALSE,top=20,Round=2)
}
\arguments{
\item{data}{dataframe or matrix}

\item{Target}{target variable}

\item{result}{"Stat" - summary statistics, "IV" - information value}

\item{clim}{maximum unique levles for categorical variable. Variables will be dropped if unique levels is higher than clim for class factor/character variable}

\item{nlim}{maximum unique values for numeric variable.}

\item{bins}{number of bins (default is 10)}

\item{Pclass}{reference category of target variable}

\item{plot}{Inforamtion value barplot (default False)}

\item{top}{for plotting top information values (default value is 20)}

\item{Round}{round of value}
}
\value{
This function provides summary statistics for categorical variable

Stat-Summary statistics includes Chi square test scores, p value, Information values, Cramers V and Degree if association

IV- Weight of evidence and Information values

Columns description:

 •	Variable – variable name

 •	Target -  Target variable label

 •	class – name of bin (variable value otherwise)

 •	out0 – number of good observations

 •	out1 – number of bad observations

 •	Total – Total values for each category

 •	pct1 – good observations / total good observations

 •	pct0 – bad observations / total bad observations

 •	odds – Odds ratio [(a/b)/(c/d)]

 •	woe – Weight of Evidence – calculated as ln(odds)

 •	iv – Information Value  - ln(odds) * (pct0 – pct1)
}
\description{
This function combines results from weight of evidence, information value and summary statistics.
}
\details{
Criteria used for categorical variable predictive power classification are

If information value is < 0.03 then predictive power = "Not Predictive"

If information value is 0.3 to 0.1 then predictive power = "Somewhat Predictive"

If information value is 0.1 to 0.3 then predictive power = "Meidum Predictive"

If information value is >0.3 then predictive power = "Highly Predictive"
}
\examples{
# Example 1
## Read mtcars data
# Target variable "am" - Transmission (0 = automatic, 1 = manual)
# Summary statistics
ExpCatStat(mtcars,Target="am",result = "Stat",clim=10,nlim=10,bins=10,
Pclass=1,plot=FALSE,top=20,Round=2)
# Information value plot
ExpCatStat(mtcars,Target="am",result = "Stat",clim=10,nlim=10,bins=10,
Pclass=1,plot=TRUE,top=20,Round=2)
# Inforamtion value for categorical Independent variables
ExpCatStat(mtcars,Target="am",result = "IV",clim=10,nlim=10,bins=10,
Pclass=1,plot=FALSE,top=20,Round=2)
}
\author{
dubrangala
}
