% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_SlidingWindows.R
\name{dmc_SlidingWindows}
\alias{dmc_SlidingWindows}
\title{Multiple detrended cross-correlation coefficient with sliding windows.}
\usage{
dmc_SlidingWindows(x1, x2, y, w, k, nu)
}
\arguments{
\item{x1}{A vector containing univariate time series.}

\item{x2}{A vector containing univariate time series.}

\item{y}{A vector containing univariate time series.}

\item{w}{An integer value indicating the window size \eqn{w < length(y)}.
If \eqn{w = length(y)}, will be computed the function will not slide.}

\item{k}{An integer value indicating the boundary of the division \eqn{(N/k)}.
The smallest value of \eqn{k} is \eqn{4}.}

\item{nu}{An integer value. See the DCCA package.}
}
\value{
A list containing "w", "dmc", "rhodcca_yx1", "rhodcca_yx2", "rhodcca_x1x2".
}
\description{
This function generates DMC Coefficient of three time series with sliding windows approach.
}
\details{
This function include following measures: w, timescale, dmc, rhodcca_yx1, rhodcca_yx2, rhodcca_x1x2
}
\examples{
x1 <- rnorm(100)
x2 <- rnorm(100)
y <- rnorm(100)
dmc_SlidingWindows(x1,x2,y,w=99,k=10,nu=0)

}
\references{
SILVA-FILHO,A.M; ZEBENDE,G.; CASTRO,A.P.; GUEDES,E. Statistical test for multiple detrended cross-correlation coefficient, Physica A, v.562, 125285, 2021.
}
