# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

Generalized_Pareto_calc_function <- function(m, c, b, rho) {
    .Call(`_SkeweDF_Generalized_Pareto_calc_function`, m, c, b, rho)
}

Generalized_Pareto_calc_pi <- function(k, theta, c, b, rho) {
    .Call(`_SkeweDF_Generalized_Pareto_calc_pi`, k, theta, c, b, rho)
}

#' Generalized Pareto Distribution Function P0 with defined delta
#' 
#' Returns P0 of Generalized Pareto given a parameters theta, c, b , and rho
#' @param theta Parameter of the Generalized Pareto function
#' @param c Parameter of the Generalized Pareto function
#' @param b  Parameter of the Generalized Pareto function
#' @param rho Parameter of the Generalized Pareto function
#' @param delta Value of difference between iterations in order to output a result. Decreasing this parameter will increase accuracy of P0. Delta > 0
#' @export
Generalized_Pareto_calc_P0_delta <- function(theta, c, b, rho, delta) {
    .Call(`_SkeweDF_Generalized_Pareto_calc_P0_delta`, theta, c, b, rho, delta)
}

#' Generalized Pareto Distribution Function P0 with defined number of iterations
#' 
#' Returns P0 of Generalized Pareto given a parameters theta, c, b , and rho
#' @param theta Parameter of the Generalized Pareto function
#' @param c Parameter of the Generalized Pareto function
#' @param b  Parameter of the Generalized Pareto function
#' @param rho Parameter of the Generalized Pareto function
#' @param iter Number of iterations to be performed for summation calcuation. Increasing this parameter will increase accuracy of P0
#' @export
Generalized_Pareto_calc_P0_iter <- function(theta, c, b, rho, iter) {
    .Call(`_SkeweDF_Generalized_Pareto_calc_P0_iter`, theta, c, b, rho, iter)
}

#' Generalized Pareto Distribution Function
#' 
#' Returns vector of length k of Generalized Pareto given a parameters theta, c, b , and rho
#' @param k Length of vector to be generated
#' @param theta Parameter of the Generalized Pareto function
#' @param c Parameter of the Generalized Pareto function
#' @param b  Parameter of the Generalized Pareto function
#' @param rho Parameter of the Generalized Pareto function
#' @export
Generalized_Pareto <- function(k, theta, c, b, rho) {
    .Call(`_SkeweDF_Generalized_Pareto`, k, theta, c, b, rho)
}

#' Kolmogorov Waring P0 calculation
#' 
#' Calculates P0 of Kolmogorov Waring distribution function given parameters
#' @param a Parameter of the Kolmogorov Waring distribution function
#' @param b Parameter of the Kolmogorov Waring distribution function
#' @param theta Parameter of the Kolmogorov Waring distribution function
#' @export
Kolmogorov_Waring_P0_calc <- function(a, b, theta) {
    .Call(`_SkeweDF_Kolmogorov_Waring_P0_calc`, a, b, theta)
}

#' Kolmogorov Waring P0
#' 
#' Calculates P0 of Kolmogorov Waring distribution function given parameters. Approximation is used if parameters meet a specific criteria.
#' @param a Parameter of the Kolmogorov Waring distribution function
#' @param b Parameter of the Kolmogorov Waring distribution function
#' @param theta Parameter of the Kolmogorov Waring distribution function
#' @export
Kolmogorov_Waring_P0 <- function(a, b, theta) {
    .Call(`_SkeweDF_Kolmogorov_Waring_P0`, a, b, theta)
}

#' Kolmogorov Waring
#' 
#' Calculates vector of n length of Kolmogorov distribution function given parameters
#' @param n Length of vector to be generated
#' @param a Parameter of the Kolmogorov Waring distribution function
#' @param b Parameter of the Kolmogorov Waring distribution function
#' @param theta Parameter of the Kolmogorov Waring distribution function
#' @export
Kolmogorov_Waring <- function(n, a, b, theta) {
    .Call(`_SkeweDF_Kolmogorov_Waring`, n, a, b, theta)
}

RGHD_P0_calc_function <- function(k, m, r, q) {
    .Call(`_SkeweDF_RGHD_P0_calc_function`, k, m, r, q)
}

RGHD_P0_calc_pi <- function(y, m, r, q) {
    .Call(`_SkeweDF_RGHD_P0_calc_pi`, y, m, r, q)
}

#' 2m-RGHD Distribution Function P0 calculation
#' 
#' Calculates P0 given a set of parameters
#' @param sigma_upper Int which determine number of iterations for calculation to go through, this is needed to approximate sigma infinity
#' @param m Parameter of the 2m-RGHD function, this defines number of r and q parameters of the function
#' @param r R vector containing r parameters from 1:m
#' @param q R vector containing q parameters from 1:m
#' @export
RGHD_P0_calc <- function(sigma_upper, m, r, q) {
    .Call(`_SkeweDF_RGHD_P0_calc`, sigma_upper, m, r, q)
}

#' 2m-RGHD Distribution Function P0
#' 
#' Calculates P0 given a set of parameters
#' @param m Parameter of the 2m-RGHD function, this defines number of r and q parameters of the function
#' @param r R vector containing r parameters from 1:m
#' @param q R vector containing q parameters from 1:m
#' @export
RGHD_P0 <- function(m, r, q) {
    .Call(`_SkeweDF_RGHD_P0`, m, r, q)
}

#' 2m-RGHD Distribution Function
#' 
#' Returns doubly truncated vector of 2m-RGHD function values where input is 1-J
#' @param J Length of vector to be generated
#' @param m Parameter of the 2m-RGHD function, this defines number of r and q parameters of the function
#' @param r R vector containing r parameters from 1:m
#' @param q R vector containing q parameters from 1:m
#' @param P0_iter Integer indicating number of iterations to use for calculation of P0, increasing this parameter will increase accuracy of P0
#' @param P0_included Boolean used to include P0 in vector or not
#' @export
RGHD <- function(J, m, r, q, P0_iter = 100L, P0_included = FALSE) {
    .Call(`_SkeweDF_RGHD`, J, m, r, q, P0_iter, P0_included)
}

