% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcr.profiles.R
\name{climProfiles}
\alias{climProfiles}
\title{Compute profiles limits}
\usage{
climProfiles(
  profiles,
  x = 1:nrow(profiles),
  smoothprof = FALSE,
  smoothlim = FALSE,
  alpha = 0.01
)
}
\arguments{
\item{profiles}{Matrix with profiles in columns}

\item{x}{Vector for the independent variable}

\item{smoothprof}{regularize profiles? [FALSE]}

\item{smoothlim}{regularize confidence bands? [FALSE]}

\item{alpha}{limit for control limits [0.01]}
}
\value{
a matrix with three profiles: prototype and confidence bands
}
\description{
Function to compute prototype profile and confidence bands for a set of profiles (Phase I)
}
\examples{
wby.phase1 <- ss.data.wby[, 1:35]
wb.limits <- climProfiles(profiles = wby.phase1,
    x = ss.data.wbx,
    smoothprof = FALSE,
    smoothlim = FALSE)
    plotProfiles(profiles = wby.phase1,
                 x = ss.data.wbx, 
                 cLimits = wb.limits)
}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\author{
Javier M. Moguerza and Emilio L. Cano
}
