% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.loa.R
\name{loa-methods}
\alias{loa-methods}
\alias{print.loa}
\alias{plot.loa}
\alias{check.loa}
\title{Methods for loa objects}
\usage{
\method{print}{loa}(x, digits = 4, ...)

\method{plot}{loa}(
  x,
  geom = c("geom_point", "geom_bin2d", "geom_density_2d", "geom_density_2d_filled",
    "stat_density_2d"),
  delta = NULL,
  ...
)

\method{check}{loa}(x)
}
\arguments{
\item{x}{object of class \code{loa} as returned from a agreement_limit function.}

\item{digits}{The number of digits to print.}

\item{...}{further arguments passed through, see description of return value
for details.
\code{\link{agreement_limit}}.}

\item{geom}{String naming the type of geometry to display the data points. Default is "geom_point". Other options include: "geom_bin2d", "geom_density_2d", "geom_density_2d_filled", and "stat_density_2d".}

\item{delta}{The maximal allowable difference.}
}
\value{
\describe{
\item{\code{print}}{Prints short summary of the Limits of Agreement.}
\item{\code{plot}}{Returns a plot of the limits of agreement.}
\item{\code{check}}{Returns plots testing the assumptions of a Bland-Altman analysis. P-values for the normality and heteroskedascity tests are provided as captions to the plot.}
}
}
\description{
Methods defined for objects returned from the agreement_limit function.
}
