% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.dome.graphics.R
\name{flux.dome.graphics}
\alias{flux.dome.graphics}
\alias{flux.dome.graph3D}
\alias{flux.dome.projections}
\title{Plot of the flux dome}
\usage{
flux.dome.graph3D(A_fun,Etot_fun,add.reg=FALSE,B_fun=NULL,
E_ini_fun=NULL,X_fun=1,marge_section=0.1,marge_top.dome=0.5)

flux.dome.projections(A_fun,Etot_fun,add.reg=FALSE,B_fun=NULL,
E_ini_fun=NULL,X_fun=1,nbniv=9,niv.palette=NULL,marge_section=0.1,
posi.legend="topleft",new.window=FALSE,cex.pt=1.5,...)
}
\arguments{
\item{A_fun}{Numeric vector of activities}

\item{Etot_fun}{Numeric value of total concentration}

\item{add.reg}{Logical. Add regulation line in plots? Default is \code{FALSE}.}

\item{B_fun}{Numeric vector of global co-regulation coefficients. Same length as \code{E_ini_fun}.}

\item{E_ini_fun}{Numeric vector of initial concentrations}

\item{X_fun}{Numeric value. Default is \code{1}}

\item{marge_section}{Numeric. Height of section up to surface dome. Default is \code{0.1}}

\item{marge_top.dome}{Numeric. Space between top dome and max of zlim. Default is \code{0.5}}

\item{nbniv}{Numeric. Number of contour lines, between 3 and 11. Default is \code{9}}

\item{niv.palette}{Character vector. Color palette to be passed to contour lines.}

\item{posi.legend}{Contour line legend position. See \emph{details}.}

\item{new.window}{Logical. Does graphics appear in a new window ? Default is \code{TRUE}}

\item{cex.pt}{Numeric. Size of points in plot(s) drawn by \code{flux.dome.projections}}

\item{...}{Arguments to be passed to \code{plot} function, such as \code{lwd} or \code{cex.axis}}
}
\value{
Function \code{flux.dome.graph3D} returns a 3D-graph of flux dome, with section in case of regulation.

Function \code{flux.dome.projections} returns a triangular diagram corresponding to the projection of the flux dome on the plan of relative concentrations.
In the case of regulation (\code{add.reg=TRUE}), a straight line is drawn.
If \code{add.reg=TRUE}, function \code{flux.dome.projections} also returns a plot of the curve defined by the intersection of the dome with the upright plan drawn from regulation line.
}
\description{
Function \code{flux.dome.graph3D} gives a 3D graph of flux dome for a three-enzyme pathway.

Function \code{flux.dome.projections} gives a triangular diagram of flux dome, 
and if \code{add.reg==TRUE}, it also gives a plot of the curve defined by the intersection of the dome with the upright plan drawn from regulation line.
}
\details{
\bold{General}

\emph{\bold{Available only for three-enzyme pathway}, i.e. length of \code{A_fun} equal to 3.}
 
\bold{Flux dome exists only in case of the competition.}

\code{E_ini_fun} is rescaled by a cross product to have sum of \code{E_ini_fun} equal to \code{Etot_fun}.

Only flux dome is returned if \code{add.reg} is \code{FALSE}.

If \code{add.reg=TRUE}, \code{E_ini_fun} and \code{B_fun} are required. Else, default is \code{NULL}.


\bold{Function \code{flux.dome.graph.3D}}

If \code{add.reg} is \code{TRUE}, a section corresponding to the upright plan drawn from line on which the relative concentrations move when there is co-regulations \emph{(see \code{\link{droites}})} is added on graph.


\bold{Function \code{flux.dome.projections}}

Projection on plan \code{(e1,e2,e3)} is from blue for low flux to red for high flux.
Colors are taken from \code{Spectral} palette of the package '\code{RColorBrewer}'.

Because contour lines are calibrated to correspond to integer values of flux, it is possible to have a difference between input and output \code{nbniv}. 
 
If \code{add.reg} is \code{TRUE}, line on which the relative concentrations move when there is co-regulations \emph{(see \code{\link{droites}})} is added on triangular diagram.
Also, a new plot of the curve defined by the intersection of the dome with the upright plan drawn from this line is drawn.

\bold{Color palette for contour lines}

By default, color palette for contour lines is taken in palette \code{"Spectral"} of package \code{RColorBrewer}, with cool colors for low flux values and warm colors for high ones.

Input your own color palette in \code{niv.palette}.

If color numbers in \code{niv.palette} is inferior to the number of contour lines \code{nbniv}, a warning message is printed and palette is replicated to have enough colors.

\code{posi.legend} is the position of the legend for contour line.
It is a character vector of length 1 (\code{"topleft"}, etc.) or a numeric vector of length 2, which is the coordinates of the upper left corner of the legend box.
If \code{NULL}, the legend will not be shown.
The first (resp. second) element of \code{posi.legend} is passed to argument \code{x} (resp. \code{y}).
Note that the minimum and maximum coordinates for the return triangular plot are between -0.864 and 0.864 for x-axis, and -0.66 and 1.064 for y-axis. Use \code{locator(1)} to adjust position legend.
}
\examples{
Etot <- 100
A <- c(1,10,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- compute.B.from.beta(beta)

#or for B :
B <- 1/c(0.2,0.5,0.3)
E0<- c(30,30,30)

flux.dome.graph3D(A,Etot,add.reg=TRUE,B,E0)
flux.dome.projections(A,Etot,add.reg=TRUE,B,E0)


#Position of legend at right
flux.dome.projections(c(1,10,30),100,posilegend=c(0.55,0.9))

}
\seealso{
See function \code{\link{droites}} to compute regulation line.
}
