% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_delta.R
\name{range_delta}
\alias{range_delta}
\title{Bounds of \emph{delta_i}}
\usage{
range_delta(E_res,alpha_fun,i_fun,tol_fun=0.0001)
}
\arguments{
\item{E_res}{Numeric vector of resident enzyme concentrations}

\item{alpha_fun}{Numeric matrix of redistribution coefficients}

\item{i_fun}{Integer number indicating the enzyme targeted by the mutation}

\item{tol_fun}{Numeric and positive value. Accuracy for delta bounds. Default is \code{0.0001}}
}
\value{
Numeric vector of the inferior and the superior bounds of actual mutation effect \eqn{\delta_i}
}
\description{
Computes the bounds of the actual mutation effect \eqn{\delta_i} such as all mutant concentrations are between 0 and total concentration, for a mutation targeting enzyme \eqn{i}
}
\details{
This function \code{range.delta} computes the bounds of \eqn{\delta_i} such as all mutant concentrations are between 0 and total concentration \eqn{Etot}, for a mutation targeting enzyme \code{i_fun}.
Mutant concentrations are equal to resident concentrations plus \eqn{\alpha_ij * \delta_i} \eqn{(see function \code{\link{mut.E.indirect}})}.
For any enzyme \eqn{j}, mutant value is \eqn{E_j^r + \alpha_ij * \delta_i}.

The inferior (resp. superior) bound of \eqn{\delta_i} corresponds to minimal (resp. maximal) value of \eqn{\delta_i}
such as all mutant concentrations are superior or equal to 0 \bold{and} inferior or equal to \eqn{Etot},
with at least one mutant concentration equal to 0 or \eqn{Etot}.

\code{tol_fun} is the accuracy (or allowed tolerance) for \eqn{\delta} bounds. It allows to avoid asymptote problem when computing the RNV.
}
\examples{
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
Er <- c(30,30,30)
correl <- "CRPos"
alpha <- alpha_ij(Er,correl,beta)

#mutant enzyme
i <- 1

range_delta(Er,alpha,i)

}
\seealso{
See function \code{\link{alpha_ij}} to compute matrix of redistribution coefficients \code{alpha_fun}.
}
