rmult.crm <-
function(clsize,lin.pred,cor.matrix,cuts,link="probit")
{
 if(!is.numeric(clsize) | clsize < 2)
     stop("'clsize' must be greater than or equal to two")
 clsize <- as.integer(clsize) 
 lin.pred <- as.matrix(lin.pred)
 if(!is.numeric(lin.pred))
     stop("'lin.pred' must be a numeric")
 if(ncol(lin.pred)!=clsize) 
     stop("'lin.pred' must have ",clsize,"columns")
 R <- nrow(lin.pred)
 if(!is.vector(cuts))
    stop("'cuts' must be a list or a vector")
 if(!is.numeric(cuts))
    stop("'cuts' must be numeric")
 if(cuts[1]!=-Inf)
   stop("'-Inf' must be the first cutpoint")
 if(cuts[length(cuts)]!=Inf)
   stop("'Inf' must be the last cutpoint")
 if(length(cuts) < 4 )
   stop("'cuts' must have at least four elements")
 if(any(diff(cuts)<=0)) 
    stop("'cuts' must be increasing") 
 ncategories <- length(cuts)-1
 lin.pred1 <- t(apply(lin.pred,1,function(x) rep(x,each=ncategories-1)))
 links <- c("probit","logit","cloglog","cauchit")
 if(!is.element(link,links)) 
   stop("'link' must be either 'probit','logit','cloglog' or'cauchit'") 
 distr <- switch(link,"probit"="normal","logit"="logistic",
                       "cloglog"="extreme","cauchit"="cauchit")
 if(!is.numeric(cor.matrix)) 
    stop("'cor.matrix' must be numeric")
 if(!is.matrix(cor.matrix))
    stop("'cor.matrix' must be matrix")
 if (!is.numeric(cor.matrix)) 
        stop("'cor.matrix' must be numeric")
    cor.matrix <- as.matrix(cor.matrix)
    dimcor <- clsize*(ncategories-1)
    if (ncol(cor.matrix) != dimcor) 
        stop("'cor.matrix' must be ", dimcor, "x", dimcor, 
            " matrix")
    if (!isSymmetric(cor.matrix)) 
        stop("'cor.matrix' must be symmetric")
    for (i in 1:clsize) {
        diag.index <- 1:(ncategories-1) + (i - 1) * (ncategories-1)
        cor.matrix[diag.index, diag.index] <- diag(1, ncategories-1)
    }
    if (any(cor.matrix > 1) | any(cor.matrix < -1)) 
        stop("all the elements of 'cor.matrix' must be on [-1,1]")
    if (any(eigen(cor.matrix, symmetric = TRUE, only.values = TRUE)$values <= 
        0)) 
        stop("'cor.matrix' must be positive definite")
  err <- rnorta(R=R,cor.matrix=cor.matrix,distr=distr)
 U <- if(distr=="extreme") lin.pred1+err else -lin.pred1+err
 Ysim <- matrix(cut(U,cuts,labels=FALSE),R,dimcor)
 Ysim <- matrix(Ysim,ncol=ncategories-1,byrow=TRUE)
 for(i in 1:(ncategories-1)) Ysim[,i] <- ifelse(Ysim[,i]==i,i,ncategories)
 Ysim <- apply(Ysim,1,min)
 Ysim <- matrix(Ysim,R,clsize,byrow=TRUE)
 if(distr=="extreme") Ysim <- max(Ysim)-Ysim+1
 list(Ysim=Ysim,correlation=cor.matrix,rlatent=err)
 }