% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{CID.GetDistMat}
\alias{CID.GetDistMat}
\title{Computes distance matrix from edge list}
\usage{
CID.GetDistMat(edges, n = 4)
}
\arguments{
\item{edges}{a data frame with two columns; V1 and V2, specifying the cell-cell edge list for the network}

\item{n}{maximum network distance to subtend (n neighbors)}
}
\value{
adjacency matrices for distances < n
}
\description{
\code{CID.GetDistMat} returns the distance matrix (i.e., adjacency matrix, second-degree adjacency matrix, ..., etc.)
from an edge list. Here, edges is the edge list, and n is the order of the connetions.
}
\examples{
\dontrun{
# Loads edges
file.dir = "https://kleintools.hms.harvard.edu/tools/client_datasets/"
file = "CITESEQ_EXPLORATORY_CITESEQ_5K_PBMCS/FullDataset_v1_protein/edges.csv"
download.file(paste0(file.dir, file, "?raw=true"), destfile = "edges.csv")

# data.dir is your path to the "edges.csv" file
edges = CID.LoadEdges(data.dir = ".")

# get distance matrix (adjacency matrices with up to fourth-order connections) from edge list
distance_matrices = CID.GetDistMat(edges)
}
}
