% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDplot.R
\name{DDplot}
\alias{DDplot}
\title{Graphical representation of difficulty and discrimination in item analysis}
\usage{
DDplot(data)
}
\arguments{
\item{data}{numeric: binary data matrix or data frame. See \strong{Details}.}
}
\description{
Plots difficulty and discrimination for items ordered by difficulty.
}
\details{
The \code{data} is a matrix or data frame whose rows represents examinee answers
("1" correct, "0" incorrect) and columns correspond to the items.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT, package = "difNLR")
data  <- GMAT[, colnames(GMAT) != "group"]

# Difficulty/Discrimination plot
DDplot(data)
}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}

