% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/integration.R
\name{MappingScore}
\alias{MappingScore}
\alias{MappingScore.default}
\alias{MappingScore.AnchorSet}
\title{Metric for evaluating mapping success}
\usage{
MappingScore(anchors, ...)

\method{MappingScore}{default}(
  anchors,
  combined.object,
  query.neighbors,
  ref.embeddings,
  query.embeddings,
  kanchors = 50,
  ndim = 50,
  ksmooth = 100,
  ksnn = 20,
  snn.prune = 0,
  subtract.first.nn = TRUE,
  nn.method = "annoy",
  n.trees = 50,
  query.weights = NULL,
  verbose = TRUE,
  ...
)

\method{MappingScore}{AnchorSet}(
  anchors,
  kanchors = 50,
  ndim = 50,
  ksmooth = 100,
  ksnn = 20,
  snn.prune = 0,
  subtract.first.nn = TRUE,
  nn.method = "annoy",
  n.trees = 50,
  query.weights = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{anchors}{AnchorSet object or just anchor matrix from the
Anchorset object returned from FindTransferAnchors}

\item{...}{Reserved for internal use}

\item{combined.object}{Combined object (ref + query) from the
Anchorset object returned}

\item{query.neighbors}{Neighbors object computed on query cells}

\item{ref.embeddings}{Reference embeddings matrix}

\item{query.embeddings}{Query embeddings matrix}

\item{kanchors}{Number of anchors to use in projection steps when computing
weights}

\item{ndim}{Number of dimensions to use when working with low dimensional
projections of the data}

\item{ksmooth}{Number of cells to average over when computing transition
probabilities}

\item{ksnn}{Number of cells to average over when determining the kernel
bandwidth from the SNN graph}

\item{snn.prune}{Amount of pruning to apply to edges in SNN graph}

\item{subtract.first.nn}{Option to the scoring function when computing
distances to subtract the distance to the first nearest neighbor}

\item{nn.method}{Nearest neighbor method to use (annoy or RANN)}

\item{n.trees}{More trees gives higher precision when using annoy approximate
nearest neighbor search}

\item{query.weights}{Query weights matrix for reuse}

\item{verbose}{Display messages/progress}
}
\value{
Returns a vector of cell scores
}
\description{
This metric was designed to help identify query cells that aren't well
represented in the reference dataset. The intuition for the score is that we
are going to project the query cells into a reference-defined space and then
project them back onto the query. By comparing the neighborhoods before and
after projection, we identify cells who's local neighborhoods are the most
affected by this transformation. This could be because there is a population
of query cells that aren't present in the reference or the state of the cells
in the query is significantly different from the equivalent cell type in the
reference.
}
\concept{integration}
