% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{TF.IDF}
\alias{TF.IDF}
\title{Term frequency-inverse document frequency}
\usage{
TF.IDF(data, verbose = TRUE)
}
\arguments{
\item{data}{Matrix with the raw count data}

\item{verbose}{Print progress}
}
\value{
Returns a matrix with the normalized data
}
\description{
Normalize binary data per cell using the term frequency-inverse document frequency
normalization method (TF-IDF).
This is suitable for the normalization of binary ATAC peak datasets.
}
\examples{
mat <- matrix(data = rbinom(n = 25, size = 5, prob = 0.2), nrow = 5)
mat_norm <- TF.IDF(data = mat)

}
