% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{RenameCells}
\alias{RenameCells}
\alias{RenameCells.Assay}
\alias{RenameCells.DimReduc}
\alias{RenameCells.Seurat}
\alias{RenameCells.VisiumV1}
\title{Rename cells}
\usage{
RenameCells(object, ...)

\method{RenameCells}{Assay}(object, new.names = NULL, ...)

\method{RenameCells}{DimReduc}(object, new.names = NULL, ...)

\method{RenameCells}{Seurat}(
  object,
  add.cell.id = NULL,
  new.names = NULL,
  for.merge = FALSE,
  ...
)

\method{RenameCells}{VisiumV1}(object, new.names = NULL, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{new.names}{vector of new cell names}

\item{add.cell.id}{prefix to add cell names}

\item{for.merge}{Only rename slots needed for merging Seurat objects.
Currently only renames the raw.data and meta.data slots.}
}
\value{
An object with new cell names
}
\description{
Change the cell names in all the different parts of an object. Can
be useful before combining multiple objects.
}
\details{
If \code{add.cell.id} is set a prefix is added to existing cell names. If
\code{new.names} is set these will be used to replace existing names.
}
\examples{
# Rename cells in an Assay
head(x = colnames(x = pbmc_small[["RNA"]]))
renamed.assay <- RenameCells(
    object = pbmc_small[["RNA"]],
    new.names = paste0("A_", colnames(x = pbmc_small[["RNA"]]))
)
head(x = colnames(x = renamed.assay))

# Rename cells in a DimReduc
head(x = Cells(x = pbmc_small[["pca"]]))
renamed.dimreduc <- RenameCells(
    object = pbmc_small[["pca"]],
    new.names = paste0("A_", Cells(x = pbmc_small[["pca"]]))
)
head(x = Cells(x = renamed.dimreduc))

# Rename cells in a Seurat object
head(x = colnames(x = pbmc_small))
pbmc_small <- RenameCells(object = pbmc_small, add.cell.id = "A")
head(x = colnames(x = pbmc_small))

}
