% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{IsGlobal}
\alias{IsGlobal}
\alias{IsGlobal.default}
\alias{IsGlobal.DimReduc}
\alias{IsGlobal.SpatialImage}
\title{Is an object global/persistent?}
\usage{
IsGlobal(object)

\method{IsGlobal}{default}(object)

\method{IsGlobal}{DimReduc}(object)

\method{IsGlobal}{SpatialImage}(object)
}
\arguments{
\item{object}{An object}
}
\value{
\code{TRUE} if the object is global/persistent otherwise \code{FALSE}
}
\description{
Typically, when removing \code{Assay} objects from an \code{Seurat} object,
all associated objects (eg. \code{DimReduc}, \code{Graph}, and \code{SeuratCommand} objects)
are removed as well. If an associated object is marked as global/persistent,
the associated object will remain even if its original assay was deleted
}
\examples{
IsGlobal(pbmc_small[['pca']])

}
