% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{FeaturePlot}
\alias{FeaturePlot}
\alias{FeatureHeatmap}
\title{Visualize 'features' on a dimensional reduction plot}
\usage{
FeaturePlot(object, features, dims = c(1, 2), cells = NULL,
  cols = c("lightgrey", "blue"), pt.size = NULL, order = FALSE,
  min.cutoff = NA, max.cutoff = NA, reduction = NULL,
  split.by = NULL, shape.by = NULL, slot = "data", blend = FALSE,
  blend.threshold = 0.5, label = FALSE, label.size = 4,
  ncol = NULL, combine = TRUE, coord.fixed = FALSE, by.col = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Vector of features to plot. Features can come from:
\itemize{
    \item An \code{Assay} feature (e.g. a gene name - "MS4A1")
    \item A column name from meta.data (e.g. mitochondrial percentage - "percent.mito")
    \item A column name from a \code{DimReduc} object corresponding to the cell embedding values
    (e.g. the PC 1 scores - "PC_1")
}}

\item{dims}{Dimensions to plot, must be a two-length numeric vector specifying x- and y-dimensions}

\item{cells}{Vector of cells to plot (default is all cells)}

\item{cols}{The two colors to form the gradient over. Provide as string vector with
the first color corresponding to low values, the second to high. Also accepts a Brewer
color scale or vector of colors. Note: this will bin the data into number of colors provided.}

\item{pt.size}{Adjust point size for plotting}

\item{order}{Boolean determining whether to plot cells in order of expression. Can be useful if
cells expressing given feature are getting buried.}

\item{min.cutoff, max.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10')}

\item{reduction}{Which dimensionality reduction to use. If not specified, first searches for umap, then tsne, then pca}

\item{split.by}{A factor in object metadata to split the feature plot by, pass 'ident'
to split by cell identity'; similar to the old \code{FeatureHeatmap}}

\item{shape.by}{If NULL, all points are circles (default). You can specify any
cell attribute (that can be pulled with FetchData) allowing for both
different colors and different shapes on cells}

\item{slot}{Which slot to pull expression data from?}

\item{blend}{Scale and blend expression values to visualize coexpression of two features}

\item{blend.threshold}{The color cutoff from weak signal to strong signal; ranges from 0 to 1.}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{ncol}{Number of columns to combine multiple feature plots to, ignored if \code{split.by} is not \code{NULL}}

\item{combine}{Combine plots into a single gg object; note that if TRUE; themeing will not work when plotting multiple features}

\item{coord.fixed}{Plot cartesian coordinates with fixed aspect ratio}

\item{by.col}{If splitting by a factor, plot the splits per column with the features as rows.}
}
\value{
A ggplot object
}
\description{
Colors single cells on a dimensional reduction plot according to a 'feature'
(i.e. gene expression, PC scores, number of genes detected, etc.)
}
\note{
For the old \code{do.hover} and \code{do.identify} functionality, please see
\code{HoverLocator} and \code{CellSelector}, respectively.
}
\examples{
FeaturePlot(object = pbmc_small, features = 'PC_1')

}
\seealso{
\code{\link{DimPlot}} \code{\link{HoverLocator}}
\code{\link{CellSelector}}
}
