% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/not_used_yet.R
\name{MultiModal_CIA}
\alias{MultiModal_CIA}
\title{Run coinertia analysis on multimodal data}
\usage{
MultiModal_CIA(object, assay.1 = "RNA", assay.2 = "CITE",
  features.1 = NULL, features.2 = NULL, num.axes = 20,
  normalize.variance = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{assay.1}{First assay for multimodal analysis. Default is RNA}

\item{assay.2}{Second assay for multimodal analysis. Default is CITE for CITE-Seq analysis.}

\item{features.1}{Features of assay 1 to consider (default is variable genes)}

\item{features.2}{Features of assay 2 to consider (default is all features, i.e. for CITE-Seq, all antibodies)}

\item{num.axes}{Number of principal axes to compute and store. Default is 20, but will calculate less if either assay has <20 features.}

\item{normalize.variance}{Return the normalized row scares, so each aexis contributes equally in downstream analysis (default is T)}
}
\value{
Returns object after CIA, with results stored in dimensional reduction cia.assay1 (ie. cia.RNA) and cia.assay2. For example, results can be visualized using DimPlot(object,reduction.use="cia.RNA")
}
\description{
CIA finds a shared correlation structure betwen two different datasets, enabling integrated downstream analysis
}
